/* Bullets */

var Bullets = [];
var BulletSS = LoadSpriteset("Bullet.rss")

function Bullet(turret)
{
	this.x = turret.x-7; this.y = turret.y-7;
	this.a = turret.a || Math.random()*Math.PI;
	this.s = 4;
	this.atk = turret.atk || 0;
	this.owner = turret;
	this.target = turret.target;
	this.img = BulletSS.images[turret.img || 0];
	this.onEnd = function(){ Bullets.splice(Bullets.indexOf(this), 1); };
	this.vx = Math.cos(this.a)*this.s;
	this.vy = Math.sin(this.a)*this.s;
}

Bullet.prototype.update = function()
{
	if (IsMapEngineRunning())
		this.img.rotateBlit(MapToScreenX(0, this.x), MapToScreenY(0, this.y), this.a);
	else this.img.rotateBlit(this.x, this.y, this.a);
	this.x += this.vx;
	this.y += this.vy;

	if (this.x > SW || this.y > SH || this.x < 0 || this.y < 0) this.onEnd();
	else if (this.hasHitTarget())
	{
		this.target.hp-=this.atk;
		
		if (this.target.hp <= 0)
		{
			this.target.dead = true;
			var index = Enemies.indexOf(this.target);
			if (index != -1) {
				Game.money += this.target.money;
				Enemies.splice(index, 1);
				this.owner.kills++;
				Game.mana++;
			}
		}
		
		this.onEnd();
	}
}

Bullet.prototype.hasHitTarget = function()
{	
	if (this.target == null) return false;
	var px = this.target.x;
	var py = this.target.y;
	
	return (this.x+8 > px && this.x+8 < px+16 && this.y+8 > py && this.y+8 < py+16);
}

function CreateBullet(turret)
{
	var bullet = new Bullet(turret);
	bullet.onEnd = function(){ Bullets.splice(Bullets.indexOf(this), 1); };
	Bullets.push(bullet);
}

function UpdateBullets()
{
	var i = Bullets.length;
	while(i--) { Bullets[i].update(); }
}